<?xml version="1.0" encoding="utf-8" ?> 
<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:HTML='http://www.w3.org/Profiles/XHTML-transitional' xmlns:dt='urn:schemas-microsoft-com:datatypes' xmlns:msxsl="urn:schemas-microsoft-com:xslt">
	<xsl:output method='html'/>
	
	<xsl:include href="../../apt/views/spreadsheetview.xslt"/>
	<xsl:include href="../../apt/core/controls.xslt"/>

	<xsl:template match='@* | node()'>
		<xsl:copy><xsl:apply-templates select="@* | node()"/></xsl:copy>
	</xsl:template>
	
	<xsl:strip-space elements="*"/>

	<xsl:variable name="comboOptions_scriptEvents">
		<option>enter</option>
		<option>leave</option>
	</xsl:variable>

	<xsl:variable name="blankRow">
		<blankRow id="999" profilerevent="start" action="pause"/>
	</xsl:variable>

	<xsl:variable name="comboOptions_objectEvents">
		<option>onabort</option>
		<option>onactivate</option>
		<option>onafterprint</option>
		<option>onafterupdate</option>
		<option>onbeforeactivate</option>
		<option>onbeforecopy</option>
		<option>onbeforecut</option>
		<option>onbeforedeactivate</option>
		<option>onbeforeeditfocus</option>
		<option>onbeforepaste</option>
		<option>onbeforeprint</option>
		<option>onbeforeunload</option>
		<option>onbeforeupdate</option>
		<option>onblur</option>
		<option>onbounce</option>
		<option>oncellchange</option>
		<option>onchange</option>
		<option>onclick</option>
		<option>oncontextmenu</option>
		<option>oncontrolselect</option>
		<option>oncopy</option>
		<option>oncut</option>
		<option>ondataavailable</option>
		<option>ondatasetchanged</option>
		<option>ondatasetcomplete</option>
		<option>ondblclick</option>
		<option>ondeactivate</option>
		<option>ondrag</option>
		<option>ondragend</option>
		<option>ondragenter</option>
		<option>ondragleave</option>
		<option>ondragover</option>
		<option>ondragstart</option>
		<option>ondrop</option>
		<option>onerror</option>
		<option>onerrorupdate</option>
		<option>onfilterchange</option>
		<option>onfinish</option>
		<option>onfocus</option>
		<option>onfocusin</option>
		<option>onfocusout</option>
		<option>onhelp</option>
		<option>onkeydown</option>
		<option>onkeypress</option>
		<option>onkeyup</option>
		<option>onlayoutcomplete</option>
		<option>onload</option>
		<option>onlosecapture</option>
		<option>onmousedown</option>
		<option>onmouseenter</option>
		<option>onmouseleave</option>
		<option>onmousemove</option>
		<option>onmouseout</option>
		<option>onmouseover</option>
		<option>onmouseup</option>
		<option>onmousewheel</option>
		<option>onmove</option>
		<option>onmoveend</option>
		<option>onmovestart</option>
		<option>onpaste</option>
		<option>onpropertychange</option>
		<option>onreadystatechange</option>
		<option>onreset</option>
		<option>onresize</option>
		<option>onresizeend</option>
		<option>onresizestart</option>
		<option>onrowenter</option>
		<option>onrowexit</option>
		<option>onrowsdelete</option>
		<option>onrowsinserted</option>
		<option>onscroll</option>
		<option>onselect</option>
		<option>onselectionchange</option>
		<option>onselectstart</option>
		<option>onstart</option>
		<option>onstop</option>
		<option>onsubmit</option>
		<option>onunload</option>
	</xsl:variable>
	
	<xsl:template match='triggers | profilertriggers'>
		<xsl:call-template name="spreadsheet_start">
			<!-- <xsl:with-param name="nohandler">true</xsl:with-param> -->
		</xsl:call-template>
		<div style='display:none;'>
			<select>
				<xsl:copy-of select='$comboOptions_scriptEvents'/>
			</select>
			<select>
				<xsl:copy-of select='$comboOptions_objectEvents'/>
			</select>
		</div>
		<table style='display:none;'>
			<xsl:for-each select='msxsl:node-set($blankRow)/blankRow'>
				<xsl:call-template name='spreadsheet_row'>
					<xsl:with-param name="hidden">no</xsl:with-param>
				</xsl:call-template>
				<xsl:call-template name='spreadsheet_row'>
					<xsl:with-param name="hidden">yes</xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
		</table>
	</xsl:template>
	
	<xsl:template name="spreadsheet_columns_def">
		<xsl:param name="hidden"/>
		<xsl:call-template name="spreadsheet_column">
			<xsl:with-param name="name">Profiler Event</xsl:with-param>
			<xsl:with-param name="width">80px</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>
			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="hidden" select="$hidden"/>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_column">
			<xsl:with-param name="name">URL</xsl:with-param>
			<xsl:with-param name="width">140px</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>
			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="hidden" select="$hidden"/>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_column">
			<xsl:with-param name="name">Function Name</xsl:with-param>
			<xsl:with-param name="width">80px</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>
			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="hidden" select="$hidden"/>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_column">
			<xsl:with-param name="name">Object</xsl:with-param>
			<xsl:with-param name="width">10px</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>
			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="hidden" select="$hidden"/>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_column">
			<xsl:with-param name="name">Event</xsl:with-param>
			<xsl:with-param name="width">80px</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>
			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="hidden" select="$hidden"/>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_column">
			<xsl:with-param name="name">Timer</xsl:with-param>
			<xsl:with-param name="width">80px</xsl:with-param>
			<xsl:with-param name="type">number</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>
			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="hidden" select="$hidden"/>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_column">
			<xsl:with-param name="name">Action</xsl:with-param>
			<xsl:with-param name="width">80px</xsl:with-param>
			<xsl:with-param name="fixedPos">true</xsl:with-param>
			<xsl:with-param name="sortable">false</xsl:with-param>
			<xsl:with-param name="hidden" select="$hidden"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="spreadsheet_rows_def">
		<xsl:param name="hidden"/>
		<xsl:for-each select='profilertrigger'>
			<xsl:call-template name="spreadsheet_row">
				<xsl:with-param name="hidden" select="$hidden"/>
			</xsl:call-template>
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template name="spreadsheet_values_def">
		<xsl:attribute name="profilertriggerid">
			<xsl:value-of select="@id"/>
		</xsl:attribute>
		<xsl:attribute name="profilertriggereventtype">
			<xsl:value-of select="@profilerevent"/>
		</xsl:attribute>
	
		<xsl:call-template name="spreadsheet_value">
			<xsl:with-param name="value">
				<xsl:call-template name='comboBox'>
					<xsl:with-param name='id'>cmbPrfevt_<xsl:value-of select="string(@id)"/></xsl:with-param>
					<xsl:with-param name='style' select='"DropDownList"'/>
					<xsl:with-param name='status' select='"enabled"'/>
					<xsl:with-param name='selected'>text=<xsl:value-of select='string(@profilerevent)'/></xsl:with-param>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_value">
			<xsl:with-param name="value">
				<input type="text" value="{string(@codebase)}" class="editable_cell" id='{concat("txtURL_",@id)}'>
					<xsl:if test=' @profilerevent != "script events" and @profilerevent != "HTML/DHTML events" '>
						<xsl:attribute name="disabled">1</xsl:attribute>
					</xsl:if>
				</input>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_value">
			<xsl:with-param name="value">
				<input type="text" value="{string(@funcname)}" class="editable_cell" id='{concat("txtFunc_",@id)}'>
					<xsl:if test=' @profilerevent != "script events" '>
						<xsl:attribute name="disabled">1</xsl:attribute>
					</xsl:if>
				</input>
			</xsl:with-param>
			
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_value">
			<xsl:with-param name="value">
				<input type="text" value="{string(@object)}" class="editable_cell" id='{concat("txtObj_",@id)}'>
					<xsl:if test=' @profilerevent != "HTML/DHTML events" '>
						<xsl:attribute name="disabled">1</xsl:attribute>
					</xsl:if>
				</input>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_value">
			<xsl:with-param name="value">
				<xsl:call-template name='comboBox'>
					<xsl:with-param name='id'>cmbEvent_<xsl:value-of select="string(@id)"/></xsl:with-param>
					<xsl:with-param name='style' select='"DropDownList"'/>
					<xsl:with-param name='status'>
						<xsl:choose>
							<xsl:when test=' @profilerevent = "script events" or @profilerevent = "HTML/DHTML events" '>enabled</xsl:when>
							<xsl:otherwise>disabled</xsl:otherwise>
						</xsl:choose>
					</xsl:with-param>
					<xsl:with-param name='selected'>text=<xsl:value-of select='string(@event)'/></xsl:with-param>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_value">
			<xsl:with-param name="value">
				<input type="text" value="{string(@timer)}" class="editable_cell_number" id='{concat("txtTimer_",@id)}'/>
			</xsl:with-param>
		</xsl:call-template>
		<xsl:call-template name="spreadsheet_value">
			<xsl:with-param name="value">
				<xsl:call-template name='comboBox'>
					<xsl:with-param name='id'>cmbAction_<xsl:value-of select="string(@id)"/></xsl:with-param>
					<xsl:with-param name='style' select='"DropDownList"'/>
					<xsl:with-param name='status' select='"enabled"'/>
					<xsl:with-param name='selected'>text=<xsl:value-of select='string(@action)'/></xsl:with-param>
				</xsl:call-template>
			</xsl:with-param>
		</xsl:call-template>
	</xsl:template>

	<xsl:template name='comboBoxOptions'>
		<xsl:param name='id'/>
		<xsl:param name='selected'/>		<!-- Selected option value -->
		
		<xsl:variable name='comboGroup' select='substring-before($id, "_")'/>
		<xsl:variable name='comboId' select='substring-after($id, "_")'/>

		<xsl:variable name='selectedName' select='substring-before($selected, "=")'/>
		<xsl:variable name='selectedValue' select='substring-after($selected, "=")'/>
	
		<xsl:choose>
			<xsl:when test='$comboGroup = "cmbPrfevt"'>
				<option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "start"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					start
				</option>
				<option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "script events"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					script events
				</option>
				<!-- <option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "HTML/DHTML events"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					HTML/DHTML events
				</option> -->
			</xsl:when>
			<xsl:when test='$comboGroup = "cmbAction"'>
				<option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "pause"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					pause
				</option>
				<option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "resume"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					resume
				</option>
				<option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "stop"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					stop
				</option>
				<option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "clear"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					clear
				</option>
				<option>
					<xsl:if test='$selectedName = "text" and $selectedValue = "snapshot"'>
						<xsl:attribute name='selected'>1</xsl:attribute>
					</xsl:if>
					snapshot
				</option>
			</xsl:when>
			<xsl:when test='$comboGroup = "cmbEvent"'>
				<xsl:variable name="events">
					<xsl:choose>
						<xsl:when test='string(@profilerevent) = "script events"'>
							<xsl:copy-of select="$comboOptions_scriptEvents"/>
						</xsl:when>
						<xsl:when test='string(@profilerevent) = "HTML/DHTML events"'>
							<xsl:copy-of select="$comboOptions_objectEvents"/>
						</xsl:when>
					</xsl:choose>
				</xsl:variable>
				<xsl:for-each select="msxsl:node-set($events)/option">
					<option>
						<xsl:if test='$selectedName = "text" and $selectedValue = string(.)'>
							<xsl:attribute name='selected'>1</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="string(.)"/>
					</option>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
